//OS version = ubuntu 16.04 LTS
//Scilab version 5.5.2

clear;
clc;

n=10;                       			 //Number of Elements

lambda=1;                     			 // defining λ

d=lambda/4;                  			//distance between the dipoles= λ/4

k=(2*%pi)/lambda;      			//defining constant k=2 π/ λ

theta=0.0001:0.01:2*%pi;                		//theta varies from 0° to 360° 

beta1=-(k*d);                        		//β1=-kd

psi=k*d.*cos(theta)+beta1;                		//Progressive Phase

AF=sin(n.*psi/2)./(n*sin(psi/2));        		//Expression for Array Factor

polarplot(theta,AF);               		 //plot for β=-kd

beta2=k*d;                        			// β2=kd

psi=k*d.*cos(theta)+beta2;                		//Progressive Phase

AF=sin(n.*psi/2)./(n*sin(psi/2));        		//Expression for Array Factor

xset('line style',3)

polarplot(theta,AF);                 		//plot for β=kd 

title("POLAR PLOT FOR ARRAY FACTOR PATTERN FOR N ELEMENT UNIFORM AMPLITUDE END FIRE ARRAY CASE: N=10, d= λ /4, β=+-(Kd)")

h1=legend('β=Kd','β=-Kd')

